import React, {Component} from 'react';
import PropTypes from 'prop-types';
import InterventiList from "./InterventiList";
import {compose} from "redux";
import {graphql} from "react-apollo";
import {authUserQuery, countInterventi, interventiQuery} from "../../../../api/queries";
import {deleteInterventoMutation} from "../../../../api/mutation";

export class InterventiListContainer extends Component {

  constructor(props) {
    super(props)
  }

  render() {
    return (
      <InterventiList {...this.props} />
    )
  }
}

export default compose(
  graphql(interventiQuery, {
    variables: {
      filtro: "",
      pagination: {
        limit: 50, offset: 0
      }
    }
  }),
  graphql(deleteInterventoMutation),
  graphql(authUserQuery, {name: 'utenteSessione'})
)(InterventiListContainer);

InterventiListContainer.defaultProps = {};

InterventiListContainer.propTypes = {};